/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertMgtPanelUtils;
import com.ibm.hwmca.fw.certs.CertPrincipal;
import com.ibm.hwmca.fw.certs.ServerCert;
import com.ibm.hwmca.fw.certs.SubjectAltNames;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CertMgtBean
extends PanelBean
implements DataBean,
CertMgtConstants {
    private static final String TRACE_MASKD = "XCRTMGBD";
    private static final String TRACE_MASKF = "XCRTMGBF";
    private static final String TRACE_MASKT = "XCRTMGBT";
    private ServerCert certificate = null;
    private ServerCert originalCertificate = null;
    private ItemDescriptor[][] m_idServerCertTable;
    private ColumnDescriptor[] m_cdServerCertTableStructure;
    private int[] m_iServerCertTableSelection;

    public CertMgtBean(ServerCert certificate, String name) {
        this.certificate = new ServerCert(certificate);
        this.originalCertificate = certificate;
        this.setBeanName(name);
        Trace.trace(TRACE_MASKT, "<->CertMgtBean(" + certificate + ", " + name + ")");
    }

    public void setServerCertTableSelection(int[] selected) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setServerCertTableSelection(...)");
        this.m_iServerCertTableSelection = selected;
    }

    public int[] getServerCertTableSelection() {
        Trace.trace(TRACE_MASKT, "<->getSigningCertTableSelection() returning " + this.m_iServerCertTableSelection);
        return this.m_iServerCertTableSelection;
    }

    public void setServerCertTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setServerCertTableRowAt(" + index + ", ...)");
        this.m_idServerCertTable[index] = items;
    }

    public ItemDescriptor[] getServerCertTableRowAt(int index) {
        Trace.trace(TRACE_MASKT, "<->getServerCertTableRowAt(" + index + ") returning " + this.m_idServerCertTable[index]);
        return this.m_idServerCertTable[index];
    }

    public int getServerCertTableRowCount() {
        if (this.certificate == null) {
            return 0;
        }
        return 7;
    }

    public int getServerCertTableRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getServerCertTableRowStructure() {
        return this.m_cdServerCertTableStructure;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void load() {
        this.initializeTable();
    }

    private void initializeTable() {
        this.m_idServerCertTable = this.certificate == null ? new ItemDescriptor[0][0] : CertMgtPanelUtils.createCertTable(this.certificate);
        this.m_cdServerCertTableStructure = new ColumnDescriptor[0];
        this.m_iServerCertTableSelection = new int[0];
    }

    public void save() {
    }

    public void panelAction(TaskActionEvent event) {
        String elementName = null;
        String actionCommand = null;
        Object principal = null;
        int[] selectedRows = null;
        Integer selectedRow = null;
        UserTaskManager utm = null;
        Object newEntry = null;
        Object taskletData = null;
        Trace.trace(TRACE_MASKT, "->panelAction() : \n\tBean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + event.getCurrentElement() + "\n\tElementName   : " + event.getElementName() + "\n\tActionCommand : " + event.getActionCommand());
        if (event != null) {
            elementName = event.getElementName();
            actionCommand = event.getActionCommand();
            utm = this.getUserTaskManager();
            if (actionCommand.equals("CreateMenu.NewServerCertificateMenuItem")) {
                CertMgtPanelUtils.sendTaskletRequest(actionCommand, null, null, this.certificate, this);
            } else if (actionCommand.equals("SelectedMenu.ModifyMenuItem")) {
                if (this.certificate != null) {
                    if (this.certificate.isSelfSigned()) {
                        selectedRows = this.getServerCertTableSelection();
                        if (selectedRows != null && selectedRows.length > 0) {
                            selectedRow = new Integer(selectedRows[0]);
                            switch (selectedRows[0]) {
                                case 4: 
                                case 5: 
                                case 6: {
                                    CertMgtPanelUtils.sendTaskletRequest(actionCommand, selectedRow, null, this.certificate, this);
                                    break;
                                }
                                default: {
                                    if (utm != null) {
                                        try {
                                            CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0015"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0016"), MsgType.ERROR_MESSAGE);
                                        }
                                        catch (HException e) {
                                            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
                                        }
                                        break;
                                    } else {
                                        break;
                                    }
                                }
                            }
                        } else if (utm != null) {
                            try {
                                CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0012"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0014"), MsgType.ERROR_MESSAGE);
                            }
                            catch (HException e) {
                                new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
                            }
                        }
                    } else if (utm != null) {
                        try {
                            CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0015"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0062"), MsgType.ERROR_MESSAGE);
                        }
                        catch (HException e) {
                            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
                        }
                    }
                } else {
                    new FrameworkLog(CertMgtConstants.LOG_INFO, 18).log();
                    if (utm != null) {
                        try {
                            CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0045"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0051"), MsgType.ERROR_MESSAGE);
                        }
                        catch (HException e) {
                            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
                        }
                    }
                }
            } else if (actionCommand.equals("AdvancedMenu.DeleteServerCertificateMenuItem")) {
                utm = this.getUserTaskManager();
                if (utm != null) {
                    Trace.trace(TRACE_MASKD, "deleting current server certificate");
                    this.certificate = null;
                    utm.refreshElement(this.getMountPrefix() + "ServerCertTable");
                }
            } else if (actionCommand.equals("AdvancedMenu.WorkWithArchivedServerCertificateMenuItem")) {
                CertMgtPanelUtils.sendTaskletRequest(actionCommand, null, this);
            } else if (actionCommand.equals("AdvancedMenu.ImportServerCertificateMenuItem")) {
                CertMgtPanelUtils.sendTaskletRequest(actionCommand, null, this);
            } else if (actionCommand.equals("AdvancedMenu.ViewSigningCertificateMenuItem")) {
                CertMgtPanelUtils.sendTaskletRequest(actionCommand, null, null, this.certificate, this);
            } else if (actionCommand.equals("ServerCertApplyButton")) {
                CertMgtPanelUtils.sendTaskletRequest(actionCommand, this.originalCertificate, null, this.certificate, this);
            } else if (elementName.equals("CancelButton")) {
                CertMgtPanelUtils.sendCancelRequest(this);
            } else {
                Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
                new FrameworkLog(CertMgtConstants.LOG_INFO, 7).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<-panelAction(...)");
    }

    public void update(Object newData) {
        HashMap taskletData = null;
        SubjectAltNames subjectAltNames = null;
        UserTaskManager utm = null;
        Map.Entry currentEntry = null;
        String currentKey = null;
        boolean panelUpdated = false;
        ServerCert newServerCert = null;
        Integer numOfDays = null;
        CertPrincipal subject = null;
        Trace.trace(TRACE_MASKF, "->update(" + newData + ")");
        taskletData = (HashMap)newData;
        Iterator i = taskletData.entrySet().iterator();
        while (i.hasNext()) {
            currentEntry = i.next();
            currentKey = (String)currentEntry.getKey();
            if (currentKey.equals("SUBJECT_ALT_NAMES")) {
                subjectAltNames = (SubjectAltNames)currentEntry.getValue();
                Trace.trace(TRACE_MASKD, "setting modifiedSubjectAltNames with: " + subjectAltNames);
                this.certificate.setSubjectAltNames(subjectAltNames);
                CertMgtPanelUtils.createItemDescriptor(this.m_idServerCertTable, 6, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "subjectAltNamesProperty").toString(), subjectAltNames.toString());
                panelUpdated = true;
                continue;
            }
            if (currentKey.equals("EXPIRATION")) {
                numOfDays = (Integer)currentEntry.getValue();
                Trace.trace(TRACE_MASKD, "setting modifiedNumOfDays with: " + numOfDays);
                this.certificate.setNumOfDays(numOfDays);
                CertMgtPanelUtils.createItemDescriptor(this.m_idServerCertTable, 3, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "validFromProperty").toString(), new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "timeOfApply").toString());
                CertMgtPanelUtils.createItemDescriptor(this.m_idServerCertTable, 4, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "validUntilProperty").toString(), numOfDays + " " + new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "fromTimeOfApply").toString());
                panelUpdated = true;
                continue;
            }
            if (currentKey.equals("SUBJECT")) {
                subject = (CertPrincipal)currentEntry.getValue();
                Trace.trace(TRACE_MASKD, "setting subject to that of server certificate :" + subject);
                this.certificate.setSubject(subject);
                this.initializeTable();
                panelUpdated = true;
                continue;
            }
            if (currentKey.equals("NEW_CERTIFICATE")) {
                newServerCert = (ServerCert)currentEntry.getValue();
                Trace.trace(TRACE_MASKD, "setting new server certificate of " + newServerCert);
                this.certificate = newServerCert;
                this.initializeTable();
                panelUpdated = true;
                continue;
            }
            if (currentKey.equals("NEW_STATE")) {
                newServerCert = (ServerCert)currentEntry.getValue();
                Trace.trace(TRACE_MASKD, "setting new server certificate of " + newServerCert);
                this.reset(newServerCert, new ServerCert(newServerCert));
                this.initializeTable();
                panelUpdated = true;
                continue;
            }
            Trace.trace(TRACE_MASKD, "Invalid update; key=" + currentKey + ", value=" + currentEntry.getValue());
        }
        if (panelUpdated && (utm = this.getUserTaskManager()) != null) {
            Trace.trace(TRACE_MASKD, "refreshing the main panel using a mount prefix of " + this.getMountPrefix());
            utm.refreshElement(this.getMountPrefix() + "ServerCertTable");
        }
        Trace.trace(TRACE_MASKF, "<-update(...)");
    }

    private void reset(ServerCert originalCertificate, ServerCert currentCertificate) {
        Trace.trace(TRACE_MASKF, "->reset(" + originalCertificate + ", " + currentCertificate + ")");
        this.originalCertificate = originalCertificate;
        this.certificate = currentCertificate;
        Trace.trace(TRACE_MASKF, "<-reset(...)");
    }
}

